#include <bits/stdc++.h>

using namespace std;

struct CvorStabla
{
    long int boja;
    long int index;
    vector<CvorStabla*> listovi;

    CvorStabla(long int index, long int boja=0)
    {
        this->index = index;
        this->boja = boja;
    }

    static CvorStabla* Pretrazi(CvorStabla *koren, long int index)
    {
        if(koren->index == index)
        {
            return koren;
        }

        for(vector<CvorStabla*>::iterator it = koren->listovi.begin(); it != koren->listovi.end(); it++)
        {
            CvorStabla *trazeni_cvor = Pretrazi(*it, index);
            if(trazeni_cvor)
            {
                return trazeni_cvor;
            }
        }

        return nullptr;
    }

    static void Izmeni(CvorStabla *koren, long int nova_boja)
    {
        koren->boja = nova_boja;
        for(vector<CvorStabla*>::iterator it = koren->listovi.begin(); it != koren->listovi.end(); it++)
        {
            Izmeni(*it, nova_boja);
        }
    }

    static int Raznobojnost(CvorStabla *koren, long int prosla_boja=0)
    {
        int raznobojnost = 0;
        if (koren->boja != prosla_boja)
        {
            raznobojnost++;
        }

        for(vector<CvorStabla*>::iterator it = koren->listovi.begin(); it != koren->listovi.end(); it++)
        {
            raznobojnost += Raznobojnost(*it, koren->boja);
        }

        return raznobojnost;
    }
};

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    long int n, q;
    cin >> n >> q;
    long int odgovori[q];

    CvorStabla koren(1);
    long int j, v;
    for (long int i = 0; i < n-1; i++)
    {
        cin >> j >> v;
        CvorStabla::Pretrazi(&koren, j)->listovi.push_back(new CvorStabla(v));
    }

    long int bi;
    for(long int i = 0; i < n; i++)
    {
        cin >> bi;
        CvorStabla::Pretrazi(&koren, i+1)->boja = bi;
    }

    long int index, boja;
    for (long int i = 0; i < q; i++)
    {
        cin >> index >> boja;
        CvorStabla *trazeni_cvor = CvorStabla::Pretrazi(&koren, index);
        CvorStabla::Izmeni(trazeni_cvor, boja);
        odgovori[i] = CvorStabla::Raznobojnost(&koren);
    }

    for (long int i = 0; i < q; i++)
    {
        cout << odgovori[i] << "\n";
    }

    return 0;
}